(() => {
  'use strict'

  // 計算結果のチェック
  function checkCalcValue(event) {
    // プラグイン設定を取得する
    const config = atPocket.plugin.app.getConfig();
    // 現在のレコードの値
    const record = event.record;
    const CalcSign = config.calc_sign;
    const CalcValue = parseFloat(config.calc_value);
    const value = record[config.calc_field].value;
    
    if (CalcSign == 1) {
      return value == CalcValue ? true : false;
    } else if(CalcSign == 2) {
      return value > CalcValue ? true : false;
    } else if(CalcSign == 3) {
      return value < CalcValue ? true : false;
    } else if (CalcSign == 4) {
      return value >= CalcValue ? true : false;
    } else if (CalcSign == 5) {
      return value <= CalcValue ? true : false;
    } else if (CalcSign == 6) {
      return value != CalcValue ? true : false;
    } else {
      return false;
    }
  }

  // レコード作成画面/編集画面 登録ボタンクリック時
  atPocket.events.on(['app.record.create.submit', 'app.record.edit.submit'], function(event) {
    // 結果チェック
    if (checkCalcValue(event)) {
      alert('計算結果が条件を満たすため、登録できません。');
      // 登録処理を行わない
      return false;
    }
  });
})();