(() => {
  'use strict';

  // プラグイン設定情報
  const config = atPocket.plugin.app.getConfig();

  // セレクトボックスオプション生成
  function createSelectBox(result) {
    // テキストタイプのみ抽出する
    const fields = result.fields.filter(fields => fields.fieldType === "TextField");
    // セレクトボックスにオプション追加
    const select = document.getElementById('location_field');
    fields.forEach(field => {
      const opt = document.createElement("option");
      opt.value = field.uniqueId;
      opt.textContent = field.caption;
      select.appendChild(opt);
    });
  }
  
  // フィールド一覧取得API実行
  atPocket.api('apps/'+ config.appId +'/fields', 'GET', {}, function (result) {
    // 成功の場合
    // セレクトボックスオプション生成
    createSelectBox(result);
  }, function(result) {
    // エラーの場合
    console.log(result);
  });
})();