(() => {
  'use strict';
  
  // プラグイン設定を取得する
  const config = atPocket.plugin.app.getConfig();

  // レコード作成画面/編集画面表示時に実行する
  atPocket.events.on(['app.record.create.show', 'app.record.edit.show'], function(event) {  
    // 座標フィールド要素を取得
    const locationField = atPocket.app.record.getFieldElement(config.location_field);
    // 座標取得用ボタンを追加
    const locationButton = document.createElement('div');
    locationButton.id = 'locationButton';
    locationButton.textContent = "取得";
    locationButton.addEventListener('click', function(){
      getLocation();
    });
    locationField.append(locationButton);
  });

  // 位置情報取得
  function getLocation() {
    // レコードの値を取得
    const record = atPocket.app.record.get();
    // 位置情報取得
    navigator.geolocation.getCurrentPosition (
      function(location) {
        // 登録用に値を生成する
        var locationText = location.coords.latitude + "," + location.coords.longitude;
        // 対象フィールドの値に位置情報をセットする
        record[config.location_field].value = locationText;
        // レコードに値をセット
        atPocket.app.record.set(record);
      },
      function(error) {
        alert("error:" + error.message);
      }
    );    
  }

})();