(() => {
  'use strict';
  
  // レコード一覧/レコード詳細画面表示時に実行する
  atPocket.events.on(['app.record.index.show', 'app.record.detail.show'], function(event) {
    // プラグイン設定を取得する
    const config = atPocket.plugin.app.getConfig();
    // 対象フィールド
    const numberField = config.number_field;
    // 比較記号
    const limitSign = config.limit_sign;
    // 比較値
    const limitValue = parseFloat(config.limit_value);
    // 表示色
    const limitColor = config.limit_color;
    
    // 画面によって処理分け
    if (event.type === 'app.record.detail.show') {
      // 詳細画面表示
      // 値のチェック
      if(checkValue(limitSign, limitValue, event.record[numberField].value)) {
        // フィールドのデータ表示要素を取得
        const element = atPocket.app.record.getFieldValueElement(numberField);
        // 文字色を変更
        element.style.color = getColor(limitColor);
      }
    } else {
      // レコード一覧表示
      // レコード一覧データをチェック
      event.records.map(function(record, index) {
        // 値のチェック
        if(checkValue(limitSign, limitValue, record[numberField].value)) {
          // レコード一覧の特定の行のフィールド要素を取得
          const element = atPocket.app.getFieldElement(numberField, index);
          // 文字色を変更
          element.style.color = getColor(limitColor);
        }
      });
    }
  });

  // 値のチェック
  function checkValue(limitSign, limitValue, value) {
    // 比較記号による処理分け
    if (limitSign == 1) {
      // 「=」の場合
      return value == limitValue ? true : false;
    } else if(limitSign == 2) {
      // 「>」の場合
      return value > limitValue ? true : false;
    } else if(limitSign == 3) {
      // 「<」の場合
      return value < limitValue ? true : false;
    } else if (limitSign == 4) {
      // 「≧」の場合
      return value >= limitValue ? true : false;
    } else if (limitSign == 5) {
      // 「≦」の場合
      return value <= limitValue ? true : false;
    } else if (limitSign == 6) {
      // 「≠」の場合
      return value != limitValue ? true : false;
    } else {
      // それ以外
      return false;
    }
  }

  // 色の取得
  function getColor(limitColor) {
    // 「黒」
    let color = "#323130";
    if (limitColor == "red") {
      // 「赤」の場合
      color = "#d42a2a";
    } else if(limitColor == "blue") {
      // 「青」の場合
      color = "#2a7dd1";
    } else if (limitColor == "green") {
      // 「緑」の場合
      color = "#18786d"
    }
    return color;
  }

})();