(() => {
  'use strict'

  // 入力状態かどうか
  let isSignatureEdit = false;

  // 新規作成・編集画面
  atPocket.events.on(['app.record.create.show', 'app.record.edit.show'], function(event) {
    // プラグイン設定取得
    const config = atPocket.plugin.app.getConfig();

    // 設定がない場合処理を終了
    if(!config.sign_field || config.sign_field == "" || !config.file_field || config.file_field == "") {
      console.log("プラグインの設定を確認してください。");
      return false;
    }
    
    // ファイルフィールドの編集可不可取得
    let fileEditable = true;
    Object.keys(event.record).forEach((key) => {
      if (key === config.file_field) {
        fileEditable = event.record[key].editable;
      }
    });
    
    // ファイル非表示
    atPocket.app.record.setFieldShown(config.file_field, false);

    // 配置するスペース
    const wrapper = atPocket.app.record.getSpaceElement(config.sign_field);

    // キャンバス枠追加
    const wrapperElement = document.createElement('div');
    wrapperElement.id = 'canvas-wrapper';
    wrapper.appendChild(wrapperElement);

    // ボタンヘッダ追加
    const signatureCanvasHeader = document.createElement('div');
    signatureCanvasHeader.className = "signature-canvas-header";
    wrapperElement.appendChild(signatureCanvasHeader);

    // 左ボタン追加
    const headerLeft = document.createElement('div');
    headerLeft.className = "header-left";
    signatureCanvasHeader.appendChild(headerLeft);

    // 右ボタン追加
    const headerRight = document.createElement('div');
    headerRight.className = "header-right";
    signatureCanvasHeader.appendChild(headerRight);

    // 署名ボタン追加
    const editButton = createButton("edit");
    editButton.addEventListener("click", () => {
      editCanvas(true);
    });
    headerLeft.appendChild(editButton);
    
    // クリアボタン追加
    const clearButton = createButton("clear");
    clearButton.addEventListener("click", () => {
      signaturePad.clear();
    });
    headerLeft.appendChild(clearButton);

    // キャンセルボタン追加
    const cancelButton = createButton("cancel");
    cancelButton.addEventListener("click", () => {
      viewFile();
      editCanvas(false, 'cancel');
    });
    headerLeft.appendChild(cancelButton);

    // 保存ボタン追加
    const uploadButton = createButton("upload");
    uploadButton.addEventListener("click", () => {
      // 何も記入されていない場合
      if (signaturePad.isEmpty()) {
        // アップロード済みのファイルがある場合
        if (existsFile(config.file_field)) {
          if(window.confirm("署名を削除します。よろしいですか？")) {
            // ファイル削除
            fileDelete(config.file_field);
          } else {
            viewFile();
          }
        }
        // 編集不可にする
        editCanvas(false);
      } else {
        canvas.toBlob(async function(blob) {
          // ファイル置換
          await fileReplace(config.file_field, blob);
          // 編集不可
          editCanvas(false);
        }, 'image/png');
      }
    });
    headerRight.appendChild(uploadButton);

    // キャンバス生成
    const canvas = document.createElement('canvas');
    canvas.id = 'signature-area';
    wrapperElement.appendChild(canvas);

    const signaturePad = new SignaturePad(canvas, {
      backgroundColor: 'rgb(245, 242, 242)'
    });

    // 入力不可
    signaturePad.off();
    changeButtonView(false);

    // 編集画面の場合、登録済みの画像を表示
    if (event.type == "app.record.edit.show") {
      viewFile();
    }

    // アップロード済み画像表示
    function viewFile() {
      // ファイルが登録されている場合
      if (existsFile(config.file_field)) {
        const file = getFile(config.file_field);
        const img = new Image();
        const ctx = canvas.getContext("2d");
        img.onload = function() {
          const x = (canvas.width - img.width) / 2;
          const y = (canvas.height - img.height) / 2;
          ctx.drawImage(img, x, y);
          ctx.fillStyle = "rgba(180, 138, 138, 0.1)";
          ctx.fillRect(0, 0, canvas.width, canvas.height);
        }
        img.src = file.thumbnailUrl + '&width=1000&height=1000';
        signaturePad.backgroundColor = 'rgb(255, 255, 255)';
      }
    }

    // 編集可/不可切替
    function editCanvas(editType, action = '') {
      if(editType) {
        signaturePad.backgroundColor = 'rgb(255, 255, 255)';
        signaturePad.clear();
        signaturePad.on();
      } else {
        if(action == 'cancel') {
          signaturePad.clear();
        }
        signaturePad.backgroundColor = 'rgb(245, 242, 242)';
        const data = signaturePad.toData();
        signaturePad.fromData(data);
        signaturePad.off();
      }
      // 入力状態
      isSignatureEdit = editType;
      // ボタン切替
      changeButtonView(editType);
    }

    // ボタン切替
    function changeButtonView(type) {
      if(type) {
        editButton.style.display = 'none';
        clearButton.style.display = '';
        cancelButton.style.display = '';
        uploadButton.style.display = '';
      } else {
        editButton.style.display = '';
        clearButton.style.display = 'none';
        cancelButton.style.display = 'none';
        uploadButton.style.display = 'none';
      }
      // ファイルフィールド編集不可の場合
      if(!fileEditable) {
        editButton.style.display = 'none';
      }
    }

    // Adjust canvas coordinate space taking into account pixel ratio,
    // to make it look crisp on mobile devices.
    // This also causes canvas to be cleared.
    function resizeCanvas() {
      const ratio = Math.max(window.devicePixelRatio || 1, 1);
      // This part causes the canvas to be cleared
      canvas.width = canvas.offsetWidth * ratio;
      canvas.height = canvas.offsetHeight * ratio;
      canvas.getContext("2d").scale(ratio, ratio);
      // If you want to keep the drawing on resize instead of clearing it you can reset the data.
      signaturePad.fromData(signaturePad.toData());
    }
    resizeCanvas();
  });

  // ファイルの存在チェック
  function existsFile(fileField) {
    const record = atPocket.app.record.get();
    if(record[fileField].value.length > 0) {
      return true;
    }
    return false;
  }

  // ファイル取得
  function getFile(fileField) {
    const record = atPocket.app.record.get();
    return record[fileField].value[0];
  }

  // ファイル削除
  function fileDelete(fileField) {
    const record = atPocket.app.record.get();
    record[fileField].value = [];
    atPocket.app.record.set(record);
  }

  // ファイル置換
  async function fileReplace(fileField, blob) {
    // レコード取得
    const record = atPocket.app.record.get();
    // ファイル名生成
    const fileName = createFileName();
    // 現在の値を削除
    record[fileField].value = [];
    // ファイルアップロード
    const fileInfo = await atPocket.app.record.upload(blob, fileName + '.png');
    // ファイル追加
    record[fileField].value.push(fileInfo);
    // レコードセット
    atPocket.app.record.set(record);
  }

  // ボタン生成
  function createButton(name) {
    const newElement = document.createElement('div');
    newElement.className = "signature-button";
    newElement.name = name;
    addContent(newElement, name);
    return newElement;
  }

  // ボタン内容
  function addContent(buttonElement, name) {
    let path = "";
    if (name == "edit") {
      path = `<svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" viewBox="0 0 24 24">`
            +`<rect fill="none" />`
            +`<path d="M18.85,10.39l1.06-1.06c0.78-0.78,0.78-2.05,0-2.83L18.5,5.09c-0.78-0.78-2.05-0.78-2.83,0l-1.06,1.06L18.85,10.39z M14.61,11.81L7.41,19H6v-1.41l7.19-7.19L14.61,11.81z M13.19,7.56L4,16.76V21h4.24l9.19-9.19L13.19,7.56L13.19,7.56z M19,17.5 c0,2.19-2.54,3.5-5,3.5c-0.55,0-1-0.45-1-1s0.45-1,1-1c1.54,0,3-0.73,3-1.5c0-0.47-0.48-0.87-1.23-1.2l1.48-1.48 C18.32,15.45,19,16.29,19,17.5z M4.58,13.35C3.61,12.79,3,12.06,3,11c0-1.8,1.89-2.63,3.56-3.36C7.59,7.18,9,6.56,9,6 c0-0.41-0.78-1-2-1C5.74,5,5.2,5.61,5.17,5.64C4.82,6.05,4.19,6.1,3.77,5.76C3.36,5.42,3.28,4.81,3.62,4.38C3.73,4.24,4.76,3,7,3 c2.24,0,4,1.32,4,3c0,1.87-1.93,2.72-3.64,3.47C6.42,9.88,5,10.5,5,11c0,0.31,0.43,0.6,1.07,0.86L4.58,13.35z"/>`
            +`</svg><span>入力</span>`;
    } else if (name == "clear") {
      path = `<span>クリア</span>`
    } else if (name == "cancel") {
      path = `<span>キャンセル</span>`
    } else {
      path = `<svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" viewBox="0 0 24 24">`
            +`<g><rect fill="none" /></g>`
            +`<g><path d="M18,15v3H6v-3H4v3c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2v-3H18z M7,9l1.41,1.41L11,7.83V16h2V7.83l2.59,2.58L17,9l-5-5L7,9z"/></g>`
            +`</svg>`
            +`<span>保存</span>`;
    }
    if(path != "") {
      buttonElement.innerHTML = path;
    }
  }

  // ファイル名
  function createFileName() {
    const now = new Date();

    const yyyy = now.getFullYear();
    const mm = String(now.getMonth() + 1).padStart(2, '0');
    const dd = String(now.getDate()).padStart(2, '0');
  
    const hh = String(now.getHours()).padStart(2, '0');
    const mi = String(now.getMinutes()).padStart(2, '0');
    const ss = String(now.getSeconds()).padStart(2, '0');
  
    return `${yyyy}${mm}${dd}${hh}${mi}${ss}`;
  }
  
  // 詳細画面表示
  atPocket.events.on(['app.record.detail.show'], function(event) {
    // プラグイン設定取得
    const config = atPocket.plugin.app.getConfig();
    // 配置するスペース
    atPocket.app.record.setFieldShown(config.sign_field, false);
  });

  // 登録ボタン押下時
  atPocket.events.on(['app.record.create.submit', 'app.record.edit.submit'], function(event) {
    // 編集モードチェック
    if (isSignatureEdit) {
      alert("入力状態のままになっています。保存かキャンセルをしてください。");
      return false;
    }
  });

})();