(() => {
  'use strict';

  // プラグインの設定を取得する
  const config = atPocket.plugin.app.getConfig();
  
  // フィールド表示変更
  function changeViewField(record) {
    // 切替対象フィールドを非表示にする
    // 対象フィールドを取得

    const hiddenFields = config.view_limit.split(',').map(val => val.trim());
   
    hiddenFields.map(function(field, index) {
      // フィールドの非表示
      atPocket.app.record.setFieldShown(field, false);
    });
    // 表示設定数を取得する
    const count = config.view_count;
    
    // 選択肢により表示を変更する
    for (let i = 1; i <= count; i++) {
      const selectVal = config[`view_select${i}`]; 
      const limitVal  = config[`view_limit${i}`];  
      // 表示設定Nの場合
      // 対象フィールドを取得
      if (record[config.view_field].value == selectVal || (record[config.view_field].value == "" && selectVal=="OPT_NONE")) {
        const viewFields = limitVal.split(',').map(val => val.trim());
        viewFields.map(function(field, index) {
          // フィールドの表示
          atPocket.app.record.setFieldShown(field, true);
        });
      }
    } 
  }
  
  // レコード作成/編集/詳細画面表示時に処理を実行
  atPocket.events.on(['app.record.create.show', 'app.record.edit.show', 'app.record.detail.show'], function(event){
    // フィールド表示変更
    changeViewField(event.record);
  });

  // レコード作成/編集画面フィールドの値変更時の処理を実行
  atPocket.events.on(['app.record.create.change','app.record.edit.change'], function(event){
    // 切替フィールド変更時
    if (event.changes.name == config.view_field) {
      // フィールド表示変更
      changeViewField(event.record);
    }
  });
})();