(() => {
  'use strict';

  // プラグイン設定情報
  const config = atPocket.plugin.app.getConfig();

  // セレクトボックスオプション生成
  function createSelectBox(result) {

    // テキストタイプのみ抽出する
    const TextFields = result.fields.filter(fields => fields.fieldType === "TextField");
    
    // それぞれのセレクトボックスにオプション追加
    const target_field1 = document.getElementById('target_field1');
    TextFields.forEach(field => {
      const opt = document.createElement("option");
      opt.value = field.uniqueId;
      opt.textContent = field.caption;
      target_field1.appendChild(opt);
    });

    const target_field2 = document.getElementById('target_field2');
    TextFields.forEach(field => {
      const opt = document.createElement("option");
      opt.value = field.uniqueId;
      opt.textContent = field.caption;
      target_field2.appendChild(opt);
    });

    const concat_field = document.getElementById('concat_field');
    TextFields.forEach(field => {
      const opt = document.createElement("option");
      opt.value = field.uniqueId;
      opt.textContent = field.caption;
      concat_field.appendChild(opt);
    });

  }
  
  // フィールド一覧取得API実行
  atPocket.api('apps/'+ config.appId +'/fields', 'GET', {}, function (result) {
    // 成功の場合
    // セレクトボックスオプション生成
    createSelectBox(result);
  }, function(result) {
    // エラーの場合
    console.log(result);
  });
})();