(() => {
  'use strict';

  // プラグイン設定を取得する
  const config = atPocket.plugin.app.getConfig();

  // レコード作成・編集画面表示
  atPocket.events.on(['app.record.create.show', 'app.record.edit.show'], function(event) {
    // 連結先フィールド変更不可
    atPocket.app.record.setFieldDisabled(config.concat_field, true);
  });
  
  // レコード作成・編集画面 フィールド変更時に実行する
  atPocket.events.on(['app.record.create.change', 'app.record.edit.change'], function(event) {
    // 現在のレコードデータ
    const record = event.record;
    // 変更フィールドが対象フィールド1, 対象フィールド2の場合に実行
    if (event.changes.name == config.target_field1 || event.changes.name == config.target_field2) {
      // テキスト連結
      const ConcatText = record[config.target_field1].value + config.seames_field + record[config.target_field2].value;
      // 値をセット
      record[config.concat_field].value = ConcatText;
    }
    // レコードデータを返却
    return record;
  });

})();