(() => {
  'use strict';

  // プラグイン設定情報
  const config = atPocket.plugin.app.getConfig();

  // セレクトボックスオプション生成
  function createSelectBox(result) {
    // テキストタイプのみ抽出する
    const textFields = result.fields.filter(fields => fields.fieldType === "TextField");
    // セレクトボックスにオプション追加
    const locationSelect = document.getElementById('location_field');
    textFields.forEach(field => {
      const opt = document.createElement("option");
      opt.value = field.uniqueId;
      opt.textContent = field.caption;
      locationSelect.appendChild(opt);
    });
    
    // スペースタイプのみ抽出する
    const viewFields = result.fields.filter(fields => fields.fieldType === "Space");
    // セレクトボックスにオプション追加
    const mapSelect = document.getElementById('map_field');
    viewFields.forEach(field => {
      const opt = document.createElement("option");
      opt.value = field.uniqueId;
      opt.textContent = field.caption;
      mapSelect.appendChild(opt);
    });
  }

  // フィールド一覧取得API実行
  atPocket.api('apps/'+ config.appId +'/fields', 'GET', {}, function (result) {
    // 成功の場合
    // セレクトボックスオプション生成
    createSelectBox(result);
  }, function(result) {
    // エラーの場合
    console.log(result);
  });
})();