(() => {
  'use strict';

  // プラグイン設定を取得する
  const config = atPocket.plugin.app.getConfig();

  // レコード詳細画面表示時に実行する
  atPocket.events.on(['app.record.detail.show'], function(event) {
    // 座標フィールド要素を取得
    const mapField = atPocket.app.record.getSpaceElement(config.map_field);
    // 座標データ取得
    const location = checkLatLng(event.record[config.location_field].value);
    if (location !== null) {
      //地図を表示するdiv要素のidを設定
      var map = L.map(mapField);
      //地図の中心とズームレベルを指定
      map.setView(location, 15);
      //表示するタイルレイヤのURLとAttributionコントロールの記述を設定して、地図に追加する
      L.tileLayer('http://tile.openstreetmap.jp/{z}/{x}/{y}.png',
          {attribution: "<a href='http://osm.org/copyright' target='_blank'>OpenStreetMap</a> contributors" }
      ).addTo(map);
      L.marker(location).addTo(map);
      //スケールコントロールを最大幅200px、右下、m単位で地図に追加
      L.control.scale({ maxWidth: 200, position: 'bottomright', imperial: false }).addTo(map);
    }
  });

  // 座標取得
  function checkLatLng(value) {
    // 値が空の場合
    if (value == "" || value == null) {
      return null;
    }
    // 入力値を[緯度,経度]に変換
    const latLng = value.split(",").map(s => s.trim());
    // 配列チェック
    if (!Array.isArray(latLng) || latLng.length !== 2) {
      return null;
    }
    // 数値変換
    const lat = parseFloat(latLng[0]);
    const lng = parseFloat(latLng[1]);
    // 数値チェック
    if (isNaN(lat) || isNaN(lng)) {
      return null;
    }
    // 緯度・経度の範囲チェック
    if(!(lat >= -90 && lat <= 90 && lng >= -180 && lng <= 180)) {
      return null;
    }
    return latLng;
}
})();